<?php
require __DIR__.'/config.php';
role_required('user');
$uid=(int)$_SESSION['user']['id'];
$today=date('Y-m-d');
$st=$db->prepare('SELECT id FROM absensi WHERE user_id=? AND tanggal=? LIMIT 1');
$st->bind_param('is',$uid,$today);
$st->execute();
$exists=$st->get_result()->fetch_assoc();
if($exists){flash('Anda sudah absen hari ini');header('Location: dashboard_user.php');exit;}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Absen</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
video,canvas{width:100%;max-width:420px;border-radius:8px}
</style>
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container">
    <a class="navbar-brand" href="dashboard_user.php">Absensi User</a>
    <div class="d-flex ms-auto">
      <a class="btn btn-light" href="logout.php">Logout</a>
    </div>
  </div>
</nav>
<div class="container py-4">
  <div class="row justify-content-center">
    <div class="col-md-6">
      <div class="card shadow-sm">
        <div class="card-body text-center">
          <h5 class="mb-3">Aktifkan Kamera dan Ambil Foto</h5>
          <div id="httpsWarn" class="alert alert-warning d-none">Kamera hanya aktif di HTTPS atau localhost.</div>
          <video id="video" autoplay playsinline class="mb-3"></video>
          <canvas id="canvas" class="d-none"></canvas>
          <div class="d-grid gap-2">
            <button id="captureBtn" class="btn btn-primary">Ambil Foto</button>
            <form id="formAbsen" method="post" action="simpan_absen.php">
              <input type="hidden" name="foto" id="fotoData">
              <button class="btn btn-success mt-2" id="saveBtn" disabled>Simpan Absensi</button>
            </form>
            <a class="btn btn-secondary" href="dashboard_user.php">Kembali</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<script>
const isHttps = location.protocol==='https:' || location.hostname==='localhost' || location.hostname==='127.0.0.1';
const video=document.getElementById('video');
const canvas=document.getElementById('canvas');
const captureBtn=document.getElementById('captureBtn');
const saveBtn=document.getElementById('saveBtn');
const fotoData=document.getElementById('fotoData');
const httpsWarn=document.getElementById('httpsWarn');
if(!isHttps){httpsWarn.classList.remove('d-none');captureBtn.disabled=true;}
async function startCam(){
  try{
    const s=await navigator.mediaDevices.getUserMedia({video:{facingMode:'user'},audio:false});
    video.srcObject=s;
  }catch(e){alert('Tidak dapat mengakses kamera');}
}
if(isHttps && navigator.mediaDevices && navigator.mediaDevices.getUserMedia){startCam();}
captureBtn.addEventListener('click',()=>{
  const w=420,h=Math.round(w*video.videoHeight/video.videoWidth||420);
  canvas.width=w;canvas.height=h;
  const ctx=canvas.getContext('2d');ctx.drawImage(video,0,0,w,h);
  const data=canvas.toDataURL('image/png');
  fotoData.value=data;saveBtn.disabled=false;
});
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
