CREATE DATABASE IF NOT EXISTS `sherifstar_absen` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
USE `sherifstar_absen`;

CREATE TABLE IF NOT EXISTS `users` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `username` VARCHAR(64) NOT NULL UNIQUE,
  `password` VARCHAR(128) NOT NULL,
  `role` ENUM('admin','user') NOT NULL DEFAULT 'user',
  `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;

CREATE TABLE IF NOT EXISTS `absensi` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `user_id` INT NOT NULL,
  `tanggal` DATE NOT NULL,
  `waktu` TIME NOT NULL,
  `foto_path` VARCHAR(255),
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_absensi_user` FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
  UNIQUE KEY `uniq_user_tanggal` (`user_id`,`tanggal`)
) ENGINE=InnoDB;

INSERT INTO `users` (`username`,`password`,`role`) VALUES ('admin','admin123','admin')
ON DUPLICATE KEY UPDATE `username`='admin';
